/*! \file
**********************************************************************************
*Title:                         Discretix Secure clock Toolkit source file
*
* Filename:                     tlk_sclk_version.c 
*
* Project, Target, subsystem:   Toolkit, Secure Clock
*
* Created:                      26.10.2008
*
* Modified:                     26.10.2008
*
* \Author                       Ira Boguslavsky
*
* \Remarks
*           Copyright (C) 2008 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/
#include "error.h"

#include "SEPDriver.h"

#include "tlk_sclk_api_errors.h"
#include "tlk_sclk_api_version.h"
#include "tlk_sclk_def.h"
#include "tlk_sclk_host_op_code.h"

#define TLK_SCLK_START_OFFSET                       0x0


/***********************/
/* TLK_ODRM_VersionGet */
/***********************/
DxError_t TLK_SCLK_VersionGet(TLK_SCLK_Version_t *aVersion_ptr)
{
    DxError_t    error;
    DxUint32_t   sramOffset = TLK_SCLK_START_OFFSET;        /* offset into SRAM */

    DxUint32_t   paramInBuffer[DX_2_WORDS_PARAMS];
    DxUint32_t   paramOutBuffer[DX_2_WORDS_PARAMS];

    if(TLK_SCLK_IS_NULL_PARAM(aVersion_ptr))
    {
        return TLK_SCLK_RC_ERROR_API_NULL_POINTER;
    }

    /************************************************************************/
    /*  Lock access to SEP                                                  */
    /************************************************************************/
    SEPDriver_Lock();

    /************************************************************************/
    /* Start sending message to SeP */
    SEPDriver_StartMessage(&sramOffset);
    
    paramInBuffer[0] = TLK_SCLK_VERSION_MSG_OP_CODE;

    error = SEPDriver_WriteParamater((DxUint32_t)paramInBuffer,
                                      sizeof(DxUint32_t) * DX_1_WORD_PARAMS,
                                      sizeof(DxUint32_t) * DX_1_WORD_PARAMS,
                                     &sramOffset,
                                      DX_FALSE);
    if(error != DX_SUCCESS)
    {
        goto end_function_unlock;
    }

    /************************************************************************/
    /* End message                                                          */
    /************************************************************************/
    SEPDriver_EndMessage(sramOffset);


    /************************************************************************/
    /* Wait for the response                                                */
    /************************************************************************/
    error = SEPDriver_POLL_FOR_REPONSE();
    if(error != DX_SUCCESS)
    {
        goto end_function_unlock;
    }

    /************************************************************************/
    /* Start reading message from the SEP                                   */
    /************************************************************************/
    /* Start the message */
    error = SEPDriver_StartIncomingMessage(&sramOffset);
    if(error)
    {
        goto end_function_unlock;
    }

    /* Read opcode + status  */
    error = SEPDriver_ReadParamater((DxUint32_t)paramOutBuffer,
                                     sizeof(DxUint32_t) * 2,
                                     sizeof(DxUint32_t) * 2,
                                    &sramOffset ,
                                     DX_FALSE);
    if(error != DX_SUCCESS)
    {
        goto end_function_unlock;
    }

    /* check the opcode */
    if(paramOutBuffer[0] != TLK_SCLK_VERSION_MSG_OP_CODE)
    {
        error = DX_WRONG_OPCODE_FROM_SEP_ERR;
        goto end_function_unlock;
    }

    /* check the status */
    if(paramOutBuffer[1] != DX_SUCCESS)
    {
        error = paramOutBuffer[1];
        goto end_function_unlock;
    }

    /* Read opcode + status  */
    error = SEPDriver_ReadParamater((DxUint32_t)aVersion_ptr,
                                    sizeof(TLK_SCLK_Version_t),
                                    sizeof(TLK_SCLK_Version_t),
                                   &sramOffset ,
                                    DX_FALSE);
    if(error != DX_SUCCESS)
    {
        goto end_function_unlock;
    }


end_function_unlock:   

    /* lock access to the SEP */
    SEPDriver_Unlock();

    return error;
    
}
